<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        // On récupère l'utilisateur par son email
        $user = User::where('email', $request->email)->first();

        // Vérification de l'existence et du mot de passe
        if (! $user || ! Hash::check($request->password, $user->password)) {
            return response()->json([
                'message' => 'Identifiants incorrects.'
            ], 401);
        }

        // Création du token avec Sanctum
        $token = $user->createToken('auth_token')->plainTextToken;

        // On renvoie tout l'objet $user (qui inclut déjà le champ 'role')
        return response()->json([
            'access_token' => $token,
            'token_type' => 'Bearer',
            'user' => [
                'id' => $user->id,
                'name' => $user->name,
                'email' => $user->email,
                'role' => $user->role, // Info cruciale pour Angular
            ]
        ]);
    }
}
