<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category; // Import du modèle

class CategoryController extends Controller
{
    // Lister toutes les catégories (pour ton select)
    public function index()
    {
       $categories = Category::withCount('products')->get();
    return response()->json($categories);
    }

    // Enregistrer une nouvelle catégorie
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|unique:categories,name|max:255'
        ]);

        $category = Category::create($validated);

        return response()->json([
            'message' => 'Catégorie créée avec succès !',
            'data' => $category
        ], 201);
    }
    // app/Http/Controllers/CategoryController.php

public function update(Request $request, $id)
{
    $category = Category::findOrFail($id);

    $validated = $request->validate([
        'name' => 'required|string|max:255|unique:categories,name,' . $id,
    ]);

    $category->update($validated);

    return response()->json([
        'message' => 'Catégorie mise à jour avec succès',
        'category' => $category
    ]);
}
}