<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{


public function index() {
    $products = Product::with('category')->get();
    return Product::with('category')->get();
}

public function getStats() {
    return response()->json([
        'total_products' => \App\Models\Product::count(),
        'total_categories' => \App\Models\Category::count(),
        'stock_value' => \App\Models\Product::sum(DB::raw('price * quantity')),
        'low_stock' => \App\Models\Product::where('quantity', '<', 5)->count(),
    ]);
}
public function store(Request $request)
{
    $validated = $request->validate([
        'name' => 'required|string',
        'reference' => 'required|string|unique:products',
        'fournisseur' => 'nullable|string|max:255',
        'price' => 'required|numeric',
        'quantity' => 'required|integer',
        'category_id' => 'nullable|integer'
    ]);

    $product = Product::create($validated);

    return response()->json([
        'message' => 'Produit ajouté avec succès !',
        'product' => $product
    ], 201);
}
public function processReturn(Request $request) {
    $request->validate([
        'product_id' => 'required|exists:products,id',
        'quantity' => 'required|integer|min:1',
        'reason' => 'required|string'
    ]);

    // 1. Enregistrer le retour
    $return = ProductReturn::create($request->all());

    // 2. Augmenter le stock du produit
    $product = Product::find($request->product_id);
    $product->increment('quantity', $request->quantity);

    return response()->json(['message' => 'Stock mis à jour avec succès']);
}

public function update(Request $request, $id) {
    $product = Product::findOrFail($id);
    $product->update($request->all());
    return response()->json(['message' => 'Produit mis à jour', 'data' => $product]);
}

public function destroy($id) {
    $product = Product::findOrFail($id);
    $product->delete();
    return response()->json(['message' => 'Produit supprimé']);
}
public function lowStock() {
    // On récupère les produits dont le stock est inférieur ou égal à 5
    $products = Product::where('quantity', '<=', 5)->with('category')->get();
    return response()->json($products);
}


    public function getHistory() {
        // 1. Les ajouts initiaux
        $additions = DB::table('products')
            ->select('name', 'quantity', 'created_at', DB::raw("'Ajout' as type"));

        // 2. Les sorties (Demandes)
        $requests = DB::table('product_requests')
            ->join('products', 'product_requests.product_id', '=', 'products.id')
            ->select('products.name', 'product_requests.quantity', 'product_requests.created_at', DB::raw("'Sortie' as type"));

        // 3. Les retours de site
        $returns = DB::table('product_returns')
            ->join('products', 'product_returns.product_id', '=', 'products.id')
            ->select('products.name', 'product_returns.quantity', 'product_returns.created_at', DB::raw("'Retour' as type"));

        // Fusion et tri par date la plus récente
        return $additions->union($requests)
            ->union($returns)
            ->orderBy('created_at', 'desc')
            ->get();
    }
}
