<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo; // N'oublie pas l'import

class Product extends Model
{
    use HasFactory;

    // On confirme à Laravel que la table s'appelle 'products'
    protected $table = 'products';

    // On autorise le remplissage de ces colonnes
    protected $fillable = [
    'category_id',
    'name',
    'reference',
    'price',
    'quantity',
        'fournisseur',
    'unit'
];
public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }
}
