<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\ProductRequest; // Import de ton modèle

class NewProductRequestNotification extends Notification
{
    use Queueable;

    // Cette variable contiendra toutes les infos de la demande
    public $requestData;

    public function __construct(ProductRequest $productRequest)
    {
        $this->requestData = $productRequest;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Nouvelle Demande de Matériel - Diginet')
        ->greeting('Bonjour Admin,')
        ->line('Une nouvelle demande de matériel vient d\'être saisie sur la plateforme.')
        ->line('**Produit :** ' . $this->requestData->product->name)
        ->line('**Quantité :** ' . $this->requestData->requested_quantity)
        ->line('**Demandeur :** ' . $this->requestData->employee_name)
        ->line('**Service :** ' . $this->requestData->service_name)
        ->line('**Site bénéficiaire :** ' . $this->requestData->site_location)
        ->action('Voir la demande', url('/dashboard')) // Lien vers ton dashboard Angular
        ->line('Merci d\'utiliser Diginet-Stock !');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
