<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_requests', function (Blueprint $table) {
            // Ajout de la clé étrangère. "nullable()" est crucial ici pour ne pas
            // casser les 3 demandes qui existent déjà dans ta base de données.
            $table->foreignId('user_id')
                ->nullable()
                ->after('id') // Place la colonne au début, après l'ID principal
                ->constrained('users')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_requests', function (Blueprint $table) {
            // On retire la clé étrangère puis la colonne en cas de rollback
            $table->dropForeign(['user_id']);
            $table->dropColumn('user_id');
        });
    }
};
