<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User; // <--- Vérifie bien cet import (Singulier)
use Illuminate\Support\Facades\Hash; // <--- Indispensable pour Hash::make

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // 1. Utilisez "User" au singulier
        User::create([
            'name' => 'Admin Diginet',
            'email' => 'admin@diginet.ci',
            'password' => Hash::make('admin123'),
            'role' => 'admin',
        ]);

        User::create([
            'name' => 'Magasinier Trésor',
            'email' => 'magasin@tresor.ci',
            'password' => Hash::make('magasin123'),
            'role' => 'magasinier',
        ]);

        User::create([
            'name' => 'Chef de Projet Alpha',
            'email' => 'chef@projet.ci',
            'password' => Hash::make('chef123'),
            'role' => 'chef_projet',
        ]);
    }
}